package com.hc_ble;

import java.util.ArrayList;
import java.util.List;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity implements OnClickListener{
    private Button scan_btn;
    BluetoothAdapter mBluetoothAdapter;
    private ArrayList<Integer> rssis;
    LeDeviceListAdapter mleDeviceListAdapter;
    ListView lv;
    private boolean mScanning;
    private boolean scan_flag;
    private Handler mHandler;
    int REQUEST_ENABLE_BT=1;

    private static final long SCAN_PERIOD = 10000;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
	
		init();
		init_ble();
		scan_flag=true;
        mleDeviceListAdapter=new LeDeviceListAdapter();
	    lv.setAdapter(mleDeviceListAdapter); 
	    
		/*listview*/
		lv.setOnItemClickListener(new AdapterView.OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> arg0,  View v, int position, long id) {
				// TODO Auto-generated method stub
			   final BluetoothDevice device = mleDeviceListAdapter.getDevice(position);
		       if (device == null) return;
		       final Intent intent = new Intent(MainActivity.this, Ble_Activity.class);
		       intent.putExtra(Ble_Activity.EXTRAS_DEVICE_NAME, device.getName());
		       intent.putExtra(Ble_Activity.EXTRAS_DEVICE_ADDRESS, device.getAddress());
		       intent.putExtra(Ble_Activity.EXTRAS_DEVICE_RSSI, rssis.get(position).toString());
		       if (mScanning) {
		        	/*ֹͣɨ豸*/
		            mBluetoothAdapter.stopLeScan(mLeScanCallback);
		            mScanning = false;
		       }
		       /*ͼMyGattDetail*/
		       startActivity(intent);
			}
		});
		
	}
	
	private void init()
	{
		scan_btn=(Button)this.findViewById(R.id.scan_dev_btn);
		scan_btn.setOnClickListener(this);
		lv=(ListView)this.findViewById(R.id.lv);
		mHandler=new Handler();
	}
	
	private void init_ble()
	{
		//ֻӲ֧
		if (!getPackageManager().hasSystemFeature(PackageManager.FEATURE_BLUETOOTH_LE)) {
		    Toast.makeText(this, getString(R.string.btn_not_support), Toast.LENGTH_SHORT).show();
		    finish();
		}
		
		// Initializes Bluetooth adapter.
		//ȡֻص
		final BluetoothManager bluetoothManager =
	   	        (BluetoothManager) getSystemService(Context.BLUETOOTH_SERVICE);
		mBluetoothAdapter = bluetoothManager.getAdapter();
		
		// Ensures Bluetooth is available on the device and it is enabled. If not,
		// displays a dialog requesting user permission to enable Bluetooth.
		// Ȩ
		if (mBluetoothAdapter == null || !mBluetoothAdapter.isEnabled()) {
		    Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
		    startActivityForResult(enableBtIntent, REQUEST_ENABLE_BT);
		}	
	}

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		 if(scan_flag)
		 {
			 mleDeviceListAdapter=new LeDeviceListAdapter();
			 lv.setAdapter(mleDeviceListAdapter);
			 scanLeDevice(true);
		 }else{	 
			 scanLeDevice(false);
			 scan_btn.setText(getString(R.string.btn_scan_device));
		 }
	}
	

    /*ɨ豸      */
	private void scanLeDevice(final boolean enable) {
        if (enable) {
            // Stops scanning after a pre-defined scan period.
            mHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    mScanning = false;
                    scan_flag=true;
                    scan_btn.setText(getString(R.string.btn_scan_device));
                    Log.i("SCAN", "stop.....................");
                    mBluetoothAdapter.stopLeScan(mLeScanCallback);
                }
            }, SCAN_PERIOD);
            /*ʼɨ豸mLeScanCallback ص*/
            Log.i("SCAN", "begin.....................");
            mScanning = true;
            scan_flag=false;
            scan_btn.setText(getString(R.string.btn_stop_device));
            mBluetoothAdapter.startLeScan(mLeScanCallback);
        } else {
        	Log.i("Stop", "stoping................");
            mScanning = false;
            mBluetoothAdapter.stopLeScan(mLeScanCallback);
            scan_flag=true;
        }
    
    }
	
	/*ɨ豸Ļص᷵BluetoothDeviceԻȡname MAC ȵ*/
	private BluetoothAdapter.LeScanCallback mLeScanCallback =
	        new BluetoothAdapter.LeScanCallback() {
		@Override
		public void onLeScan(final BluetoothDevice device, final int rssi, byte[] scanRecord) {
			// TODO Auto-generated method stub
				
			runOnUiThread(new Runnable() {
                @Override
                public void run() {
                	/*ɨ赽豸Ϣlistview*/
                	mleDeviceListAdapter.addDevice(device,rssi);
                	mleDeviceListAdapter.notifyDataSetChanged();
                }
            });
			
			System.out.println("Address:"+device.getAddress());
			System.out.println("Name:"+device.getName());
			System.out.println("rssi:"+rssi);	
		}
	};
		
	 // Adapter for holding devices found through scanning.
    private class LeDeviceListAdapter extends BaseAdapter {
        private ArrayList<BluetoothDevice> mLeDevices;
        
        private LayoutInflater mInflator;
         
        public LeDeviceListAdapter() {
            super();
            rssis=new ArrayList<Integer>();
            mLeDevices = new ArrayList<BluetoothDevice>();
            mInflator = getLayoutInflater();
        }

        public void addDevice(BluetoothDevice device,int rssi) {
            if(!mLeDevices.contains(device)) {
                mLeDevices.add(device);
                rssis.add(rssi);
            }
        }

        public BluetoothDevice getDevice(int position) {
            return mLeDevices.get(position);
        }

        public void clear() {
            mLeDevices.clear();
            rssis.clear();
        }

        @Override
        public int getCount() {
            return mLeDevices.size();
        }

        @Override
        public Object getItem(int i) {
            return mLeDevices.get(i);
        }

        @Override
        public long getItemId(int i) {
            return i;
        }

        @Override
        public View getView(int i, View view, ViewGroup viewGroup) {
          
            // General ListView optimization code.
           
            view = mInflator.inflate(R.layout.listitem, null);
            
            TextView deviceAddress = (TextView) view.findViewById(R.id.tv_deviceAddr);
            TextView deviceName = (TextView) view.findViewById(R.id.tv_deviceName);
            TextView rssi = (TextView) view.findViewById(R.id.tv_rssi);
              
            BluetoothDevice device = mLeDevices.get(i);
            deviceAddress.setText(device.getAddress());
            deviceName.setText(device.getName());
            rssi.setText(""+rssis.get(i));
            
            return view;
        }
    }


    
}
